#!/bin/sh

if [ $# -ne 1 ]; then
  echo "usage. $0 filename"
  exit 255
fi

DIR=`dirname "${0}"`

FILENAME=$1

FTPD_ENABLE=`"${DIR}/get_parameter/get_ftp_enable_from_csv.sh" "${FILENAME}"`

if [ $FTPD_ENABLE -eq 0 ]; then
  # stop
  echo stop ftpd
  /etc/init.d/vsftpd stop
else
  # start
  echo start ftpd
  /etc/init.d/vsftpd start
fi

RESULT=$?

if [ ${RESULT} -eq 0 ] || [ ${RESULT} -eq 1 ]; then
  # 正常の場合（すでに起動中、または停止中も正常とみなす）
  exit 0
fi

exit ${RESULT}
